<?php

/*
if (isset($_SERVER['HTTP_ORIGIN'])) {
   header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
}
*/
/*
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: HEAD, OPTIONS, GET, CREATE, POST, PUT");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With, X-PINGOTHER");
*/
/*
//header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS, PUT, DELETE, CREATE");            
header("Access-Control-Allow-Credentials: true");            
header("Access-Control-Max-Age: 86400");            
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, PWC-Device-Type");            
*/

if (!class_exists('Database'))
{
class Database{
    
    private $host = "localhost";
    private $db_name = "kadamiec_chatbot";
    private $username = "kadamiec_chatbot";
    private $password = "Jt3BLBmPgKI7";
    public $conn;
     
    public function getConnection(){
 
        $this->conn = null;
 
        try{
            $this->conn = new PDO("mysql:host=" . $this->host . ";dbname=" . $this->db_name, $this->username, $this->password);
            $this->conn->exec("set names utf8");
        }catch(PDOException $exception){
            echo "Connection error: " . $exception->getMessage();
        }
 
        return $this->conn;
    }
}
}

if (!class_exists('Query'))
{
class Query{
    
    private $conn=null;
    public $numRows=null;
    public $result=null;
    public $last_id=null;
    
    public function __construct()
    {
        $db = new Database();
        $this->conn = $db->getConnection();
    }
    
    public function getData($query, $params=null)
    {
        $res = $this->conn->prepare($query);
        
        if (count($params) > 0)
        {
            for ($i=0;$i<count($params);$i++)
            {
                $data_type = PDO::PARAM_STR;
                if (isset($params[$i]['data_type'])) {$data_type = $params[$i]['data_type'];}
                $res->bindParam($params[$i]['name'], $params[$i]['value'], $data_type);
            }
        }
        
        if ($res->execute()) {
            
            $this->numRows = $res->rowCount();
            $this->result = $res;
            return true;
        } else {
            return false;
        }
    }
    
    public function insertData($query, $params=null)
    {
        $res = $this->conn->prepare($query);
        
        if (count($params) > 0)
        {
            for ($i=0;$i<count($params);$i++)
            {
                $res->bindParam($params[$i]['name'], $params[$i]['value']);
            }
        }
        
        if ($res->execute()) {
            $this->numRows = $res->rowCount();
            $this->result = $res;
            $this->last_id = $this->conn->lastInsertId();
            return true;
        } else {
            return false;
        }
    }
    
    public function updateData($query, $params=null)
    {
        return $this->getData($query, $params);
    }
    
}
}