<?php

class chatService
{
    private $Query;
    private $Query2;
    private $session_id;
    private $session_mysql_id;
    
    public function __construct() {
        $this->Query = new \Query();
        $this->Query2 = new \Query();
    }
    
    public function archiveRequest($data)
    {
        $data = json_encode($data);
        $params2 = array();
        $params2[] = array("name"=> ":wartosc", "value" => $data);         
        $this->Query->insertData("INSERT INTO test (value) VALUES (:wartosc)", $params2);
        return true;
    }
    
    public function getIntentResponse($data)
    {
        $wynik = false;
        if (isset($data->queryResult))
        {
            if (isset($data->queryResult->intent))
            {
                
                $params2 = array();
                $params2[] = array("name"=> ":name", "value" => $data->queryResult->intent->displayName);     
                $this->Query->getData("SELECT * FROM intents_custom WHERE name = :name");
                $row = $this->Query2->result->fetch(PDO::FETCH_ASSOC);
                switch ($data->queryResult->intent->displayName) {
                    case 'SAP_password_expired':$wynik = $this->createTicket($data);break;
                    case 'EMAIL_dane_finansowe':$wynik = $this->findAndSendFile($data);break;
                    case 'FAKTURA_download':$wynik = $this->downloadInvoice($data);break;
                    default:$wynik = $this->unknownAction($data);break;
                }
                
            }
        }
        return $wynik;
    }
    
    private function downloadInvoice($data)
    {
        if ($this->getUserVariable('invoice_number') >= 40000 && $this->getUserVariable('invoice_number') <= 66085)
        {
        $zm1 = array("type" => 'button', "icon" => array("type" => "cloud_download", "color" => "#FF9800"), "text" => 'Faktura #'.$this->getUserVariable('invoice_number').'', "link" => "https://veen-e.ewipro.com:7443/InvoicePrint/".$this->getUserVariable('invoice_number')."");
        $zm2[] = $zm1;
        $zm3[] = $zm2;
        $fulfillmentMessage = array("payload" => array('richContent' => $zm3));
        $answers[] = $fulfillmentMessage;
        } else {
            $fulfillmentMessage = array("text" => array('text' => array('Niestety, faktura o numerze '.$this->getUserVariable('invoice_number').' nie istnieje. Sprobuj ponownie upewniając się co do poprawności podanego numeru faktury.')));
            $answers[] = $fulfillmentMessage;        
        }
        
        $wynik = array(
            "fulfillmentMessages" => $answers
        );
        
        return $wynik;
    }
    
    private function findAndSendFile($data)
    {
        $attachment = '/ChatBotWebHook/download/Dane Finansowe do MVP.xlsx';
        $attachment_type = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
        $message = 'Witaj, <br />Poszukiwany przez Ciebie plik znajdziesz w tym e-mailu.<br /><br />Z pozdrowieniami,<br />Automatyczny asystent.';        
        $this->sendFileOnEmail($this->getUserVariable('user_email'), 'Wiadomość zawierająca poszukiwany plik.', $message, $attachment, $attachment_type);
        
        $fulfillmentMessage = array("text" => array('text' => array('Znalazłem plik, którego szukasz.')));
        $answers[] = $fulfillmentMessage;
        $fulfillmentMessage = array("text" => array('text' => array('Właśnie przesłałem do Ciebie wiadomość e-mail na adres: '.$this->getUserVariable('user_email').' wraz z plikiem, o który prosiłeś.')));
        $answers[] = $fulfillmentMessage;
        
        $wynik = array(
            "fulfillmentMessages" => $answers
        );
        
        return $wynik;
    }
    
    private function sendFileOnEmail($to, $subject, $message, $attachment, $attachment_type)
    {
        $mail = new \MailService();
        $mail->setEmail($to);
        $mail->setSubject($subject);
        $mail->setMessage($message);
        $mail->setAttachment(array("file" => $attachment, "type" => $attachment_type));
        $mail->wyslijMail();
        return true;
    }
    
    private function unknownAction($data)
    {
        $wynik = false;
        $answers = array();
        
        $fulfillmentMessage = array("text" => array('text' => array('Przykro mi, coś poszło nie tak. Nie potrafię Ci w tym momencie pomóc. Dzieje się ze mną coś niedobrego.')));
        $answers[] = $fulfillmentMessage;
        
        $wynik = array(
            "fulfillmentMessages" => $answers
        );
        
        return $wynik;
    }
    
    private function createTicket($data)
    {
        $wynik = false;
        $answers = array();
        try
        {
        $title = 'Hasło użytkownika SAP wygasło.';
        $title = json_encode($title);
        $tresc = 'Użytkownik o loginie: <b>'.$this->getUserVariable('sap_username').'</b> prosi o zresetowania hasła dostępu do programu SAP.<br /><br />Nazwa połączenia: <b>'.$this->getUserVariable('sap_connection_name').'</b>';
        $tresc = json_encode($tresc);
        $params2 = array();
        $params2[] = array("name"=> ":stamp", "value" => time());
        $params2[] = array("name"=> ":session_id", "value" => $this->session_mysql_id);
        $params2[] = array("name"=> ":tytul", "value" => $title);        
        $params2[] = array("name"=> ":tresc", "value" => $tresc);        
        $this->Query->insertData("INSERT INTO it_helpdesk (stamp, session_id, tytul, tresc) VALUES (:stamp, :session_id, :tytul, :tresc)", $params2);
        } catch (Exception $ex)
        {
            $params2 = array();
            $params2[] = array("name"=> ":logg", "value" => $ex);
            $this->Query->insertData("INSERT INTO log (log) VALUES (:logg)", $params2);
            
        }
        $fulfillmentMessage = array("text" => array('text' => array('Sprawdziłem dla Ciebie Twoje konto w systemie SAP. Faktycznie, Twoje hasło zostało wygasło. Pozwól, że skontaktuję się w Twoim imieniu z pomocą techniczną...')));
        $answers[] = $fulfillmentMessage;
        $fulfillmentMessage = array("text" => array('text' => array('Zapisałem zgłoszenie do systemu IT HelpDesk. Ktoś z pomocy informatycznej wkrótce się z Tobą skontaktuje.')));
        $answers[] = $fulfillmentMessage;
        
        $wynik = array(
            "fulfillmentMessages" => $answers
        );
        
        return $wynik;
    }
    
    private function getUserVariable($varName)
    {
        $wynik = '';
        
        $params2 = array();
        $params2[] = array("name"=> ":varname", "value" => $varName);
        $params2[] = array("name"=> ":session_id", "value" => $this->session_mysql_id);
        $this->Query2->getData("SELECT * FROM sessions_variables WHERE variable_name = :varname AND session_id = :session_id", $params2);
        if ($this->Query2->numRows > 0)
        {
            $row = $this->Query2->result->fetch(PDO::FETCH_ASSOC);
            $wynik = $row['variable_value'];
        }
        return $wynik;              
    }
    
    public function saveVariables($data)
    {
        $keys = 'test';
        if (isset($data->queryResult))
        {
            $keys = 'test2';
            if (isset($data->queryResult->parameters))
            {                        
                            $keys = get_object_vars($data->queryResult->parameters);
                            $keys = array_keys($keys);
                            foreach ($keys as $key)
                            {
                                if ($key != 'no-input' && $key != 'no-match' && strstr($key, "original")===False)
                                {
                                    $this->saveVariable($data->queryResult->parameters->$key, $key);
                                }
                            }
            }
        }
        return $keys;
    }
    
    private function saveVariable($value, $key)
    {
        $params2 = array();
        $params2[] = array("name"=> ":session_id", "value" => $this->session_mysql_id);
        $params2[] = array("name"=> ":variable_name", "value" => $key);                
        $this->Query2->getData("SELECT * FROM sessions_variables WHERE session_id = :session_id AND variable_name = :variable_name", $params2);        
        if ($this->Query2->numRows > 0)
        {
            $row = $this->Query2->result->fetch(PDO::FETCH_ASSOC);
            $params2 = array();
            $params2[] = array("name"=> ":row_id", "value" => $row['id']);
            $params2[] = array("name"=> ":variable_value", "value" => $value);
            $this->Query->insertData("UPDATE sessions_variables SET variable_value = :variable_value WHERE id = :row_id", $params2);
        } else {
            $params2[] = array("name"=> ":variable_value", "value" => $value);
            $this->Query->insertData("INSERT INTO sessions_variables (session_id, variable_name, variable_value) VALUES (:session_id, :variable_name, :variable_value)", $params2);
        }
        return true;
    }
    
    public function openSessionIfRequired($data)            
    {
        $wynik = true;
        $params2 = array();
        $sessionId = $this->getSessionIdFromString($data->session);
        if ($sessionId != false)
        {
            $params2[] = array("name"=> ":session_id", "value" => $sessionId); 
            $this->Query->getData("SELECT * FROM sessions WHERE session_id = :session_id", $params2);
            if ($this->Query->numRows)
            {
                //sesja istnieje
                $row = $this->Query->result->fetch(PDO::FETCH_ASSOC);
                $this->session_mysql_id = $row['id'];                
            } else {
                //otworz nowa sesje
                $params2 = array();
                $params2[] = array("name"=> ":session_id", "value" => $sessionId); 
                $this->Query2->insertData("INSERT INTO sessions (session_id) VALUES (:session_id)", $params2);
            }
            $this->session_id = $sessionId;            
        } else {
            $wynik = false;
        }
        return $wynik;
    }
    
    private function getSessionIdFromString($sessionString)
    {
        $wynik = false;
        if ($sessionString != '')
        {
            $tab = explode('/', $sessionString);
            $num = count($tab);
            $wynik = $tab[$num-1];
        }
        return $wynik;
    }
}